/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.ui.hover;

import com.aptana.editor.common.hover.AbstractDocumentationHover;
import com.aptana.editor.common.hover.CustomBrowserInformationControl;
import com.aptana.editor.php.PHPEditorPlugin;
import com.aptana.editor.php.internal.ui.hover.AbstractPHPTextHover;
import com.aptana.editor.php.internal.ui.hover.PHPHoverRegistry;
import com.aptana.editor.php.internal.ui.hover.PHPTextHoverDescriptor;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.ui.IEditorPart;

public class PHPBestMatchHover
extends AbstractPHPTextHover {
    private static final String DEBUG_HOVER_ID = "com.aptana.php.debug.debugHover";
    private List<PHPTextHoverDescriptor> textHoverDescriptors = PHPHoverRegistry.getInstance().getTextHoversDescriptors();
    private List<AbstractPHPTextHover> instantiatedTextHovers = new ArrayList<AbstractPHPTextHover>(this.textHoverDescriptors.size());
    private AbstractPHPTextHover bestHover;

    public Object getHoverInfo2(ITextViewer textViewer, IRegion hoverRegion) {
        this.checkHovers();
        for (AbstractPHPTextHover hover : this.instantiatedTextHovers) {
            hover.setEditor(this.getEditor());
            Object info = hover.getHoverInfo2(textViewer, hoverRegion);
            if (info == null) continue;
            this.bestHover = hover;
            return info;
        }
        return null;
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        Object info = this.getHoverInfo2(textViewer, hoverRegion);
        if (info != null) {
            return info.toString();
        }
        return null;
    }

    public IInformationControlCreator getHoverControlCreator() {
        if (this.bestHover instanceof ITextHoverExtension) {
            return this.bestHover.getHoverControlCreator();
        }
        return super.getHoverControlCreator();
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        if (this.bestHover instanceof IInformationProviderExtension2) {
            return ((IInformationProviderExtension2)this.bestHover).getInformationPresenterControlCreator();
        }
        return super.getInformationPresenterControlCreator();
    }

    protected void checkHovers() {
        for (PHPTextHoverDescriptor descriptor : new ArrayList<PHPTextHoverDescriptor>(this.textHoverDescriptors)) {
            try {
                AbstractPHPTextHover hover = descriptor.createTextHover();
                if (hover == null) continue;
                if (DEBUG_HOVER_ID.equals(descriptor.getId())) {
                    this.instantiatedTextHovers.add(0, hover);
                } else {
                    this.instantiatedTextHovers.add(hover);
                }
                this.textHoverDescriptors.remove(descriptor);
            }
            catch (Exception e) {
                PHPEditorPlugin.logError(e);
            }
        }
    }

    public String getHeader(Object element, IEditorPart editorPart, IRegion hoverRegion) {
        if (this.bestHover instanceof AbstractDocumentationHover) {
            return this.bestHover.getHeader(element, editorPart, hoverRegion);
        }
        return null;
    }

    public String getDocumentation(Object element, IEditorPart editorPart, IRegion hoverRegion) {
        if (this.bestHover instanceof AbstractDocumentationHover) {
            return this.bestHover.getDocumentation(element, editorPart, hoverRegion);
        }
        return null;
    }

    public void populateToolbarActions(ToolBarManager tbm, CustomBrowserInformationControl iControl) {
        if (this.bestHover instanceof AbstractDocumentationHover) {
            this.bestHover.populateToolbarActions(tbm, iControl);
        }
    }
}

